package com.ejie.detailinfo.parser;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.ejie.ab04b.exception.AB04BParseException;
import com.ejie.ab04b.parse.MessageParser;

/**
 * 
 * @author GFI-NORTE
 * 
 */
public final class DetailInfoParser {

	private static DetailInfoParser instance;

	private static final Logger LOGGER = LoggerFactory
			.getLogger(DetailInfoParser.class);

	/**
	 * Constructor privado ya que ha de utilizarse el método getInstance().
	 */
	private DetailInfoParser() {

	}

	/**
	 * Devuelve la instancia de tipo DokusiUtil.
	 *
	 * @return Devuelve la instancia de tipo DokusiUtil
	 */
	public static final DetailInfoParser getInstance() {
		if (DetailInfoParser.instance == null) {
			DetailInfoParser.instance = new DetailInfoParser();
		}
		return DetailInfoParser.instance;
	}

	/**
	 * Devuelve un objeto T65BDocumentIDType a partir de su representación XML
	 * en String.
	 *
	 * @param response            String
	 * @return T65BDocumentIDType
	 * @throws AB04BParseException             expcepción al parsear la respuesta de Dokusi
	 */
	public com.ejie.detailinfo.aperturassoltel.xml.DetailInfo getDetailInfoAperturasSolTel(
			String response) throws AB04BParseException {

		DetailInfoParser.LOGGER.info("getDetailInfoAperturasSolTel");

		com.ejie.detailinfo.aperturassoltel.xml.DetailInfo obj = null;
		try {
			obj = (com.ejie.detailinfo.aperturassoltel.xml.DetailInfo) new MessageParser<com.ejie.detailinfo.aperturassoltel.xml.DetailInfo>(
					com.ejie.detailinfo.aperturassoltel.xml.DetailInfo.class
							.getPackage().getName()).parse(response);
		} catch (Exception e) {
			DetailInfoParser.LOGGER
					.error("Error en el parseo del objeto response como DetailInfo",
							e);

			throw new AB04BParseException(
					e,
					"LOG NEGOCIO: getDetailInfoAperturasSolTel --> Error en el parseo del objeto response como DetailInfo");
		}

		return obj;
	}

}
